<?php
/*
 * @brief  ,   .
 *
 *     IPGeoBase.  IP     IPGeoBase,  MaxMind GeoLite.
 *            .
 *
 * @param ip IP-
 * @return     array('country' => , 'region' => , 'city' => ),  - false
 */
function getGeoLocation($ip)
{
    global $arGeoCodes;

    //GeoIP
    require_once(dirname(__FILE__) . "/geo/geoip.inc");
    require_once(dirname(__FILE__) . "/geo/geoipcity.inc"); //GeoLite City
    require_once(dirname(__FILE__) . "/geo/geoipregionvars.php");
    require_once(dirname(__FILE__) . "/geo/ipregionvars.ru.php"); //   RU  UA

    //IpGeoBase
    require_once(dirname(__FILE__) . "geo/ipgeobase.php");

    $gi = geoip_open(dirname(__FILE__) . "geo/GeoLiteCity.dat", GEOIP_STANDARD);

    $gb = new IPGeoBase();

    $country = $region = $city = '';
    $data = $gb->getRecord($ip);
    if($data)
    {
        /*foreach($data as &$v)
        {
            $v = iconv('windows-1251', 'utf-8', $v);
        }
        unset($v);*/
        $country = !empty($data['cc']) ? $arGeoCodes[$data['cc']] : '';
        $region = !empty($data['region']) ? $data['region'] : '';
        $city = !empty($data['city']) ? $data['city'] : '';
    }

    if(!in_array($data['cc'], array('RU', 'UA')))
    {
        $record = geoip_record_by_addr($gi, $ip);

        if($record)
        {
            $country = !empty($record->country_code) ? $arGeoCodes[$record->country_code] : '';
            $region = isset($GEOIP_REGION_NAME[$record->country_code][$record->region]) ? $GEOIP_REGION_NAME[$record->country_code][$record->region] : $record->region;
            $city = $record->city;
            geoip_close($gi);
        }
    }

    if($country)
    {
        return array('country' => $country, 'region' => $region, 'city' => $city);
    }
    else
    {
        return false;
    }

}

$arGeoCodes = array(
    'AU' => '',
    'AT' => '',
    'AZ' => '',
    'AX' => ' ',
    'AL' => '',
    'DZ' => '',
    'VI' => '  ',
    'AS' => ' ',
    'AI' => '',
    'AO' => '',
    'AD' => '',
    'AQ' => '',
    'AG' => '  ',
    'AR' => '',
    'AM' => '',
    'AW' => '',
    'AF' => '',
    'BS' => '',
    'BD' => '',
    'BB' => '',
    'BH' => '',
    'BZ' => '',
    'BY' => '',
    'BE' => '',
    'BJ' => '',
    'BM' => '',
    'BG' => '',
    'BO' => '',
    'BQ' => ', -  ',
    'BA' => '  ',
    'BW' => '',
    'BR' => '',
    'IO' => '    ',
    'VG' => '  ',
    'BN' => '',
    'BF' => '-',
    'BI' => '',
    'BT' => '',
    'VU' => '',
    'VA' => '',
    'GB' => '',
    'HU' => '',
    'VE' => '',
    'UM' => '   ()',
    'TL' => ' ',
    'VN' => '',
    'GA' => '',
    'HT' => '',
    'GY' => '',
    'GM' => '',
    'GH' => '',
    'GP' => '',
    'GT' => '',
    'GF' => '',
    'GN' => '',
    'GW' => '-',
    'DE' => '',
    'GG' => '',
    'GI' => '',
    'HN' => '',
    'HK' => '',
    'GD' => '',
    'GL' => '',
    'GR' => '',
    'GE' => '',
    'GU' => '',
    'DK' => '',
    'JE' => '',
    'DJ' => '',
    'DM' => '',
    'DO' => ' ',
    'CD' => ' ',
    'EU' => ' ',
    'EG' => '',
    'ZM' => '',
    'EH' => ' ',
    'ZW' => '',
    'IL' => '',
    'IN' => '',
    'ID' => '',
    'JO' => '',
    'IQ' => '',
    'IR' => '',
    'IE' => '',
    'IS' => '',
    'ES' => '',
    'IT' => '',
    'YE' => '',
    'CV' => '-',
    'KZ' => '',
    'KY' => ' ',
    'KH' => '',
    'CM' => '',
    'CA' => '',
    'QA' => '',
    'KE' => '',
    'CY' => '',
    'KG' => '',
    'KI' => '',
    'TW' => ' ',
    'KP' => '',
    'CN' => '',
    'CC' => ' ',
    'CO' => '',
    'KM' => '',
    'CR' => '-',
    'CI' => '-',
    'CU' => '',
    'KW' => '',
    'CW' => '',
    'LA' => '',
    'LV' => '',
    'LS' => '',
    'LR' => '',
    'LB' => '',
    'LY' => '',
    'LT' => '',
    'LI' => '',
    'LU' => '',
    'MU' => '',
    'MR' => '',
    'MG' => '',
    'YT' => '',
    'MO' => '',
    'MK' => '',
    'MW' => '',
    'MY' => '',
    'ML' => '',
    'MV' => '',
    'MT' => '',
    'MA' => '',
    'MQ' => '',
    'MH' => ' ',
    'MX' => '',
    'FM' => '',
    'MZ' => '',
    'MD' => '',
    'MC' => '',
    'MN' => '',
    'MS' => '',
    'MM' => '',
    'NA' => '',
    'NR' => '',
    'NP' => '',
    'NE' => '',
    'NG' => '',
    'NL' => '',
    'NI' => '',
    'NU' => '',
    'NZ' => ' ',
    'NC' => ' ',
    'NO' => '',
    'AE' => '',
    'OM' => '',
    'BV' => ' ',
    'IM' => ' ',
    'CK' => ' ',
    'NF' => ' ',
    'CX' => ' ',
    'PN' => ' ',
    'SH' => '  ,   --',
    'PK' => '',
    'PW' => '',
    'PS' => '  ',
    'PA' => '',
    'PG' => '   ',
    'PY' => '',
    'PE' => '',
    'PL' => '',
    'PT' => '',
    'PR' => '-',
    'CG' => ' ',
    'KR' => ' ',
    'RE' => '',
    'RU' => '',
    'RW' => '',
    'RO' => '',
    'SV' => '',
    'WS' => '',
    'SM' => '-',
    'ST' => '-  ',
    'SA' => ' ',
    'SZ' => '',
    'MP' => '  ',
    'SC' => ' ',
    'BL' => '-',
    'MF' => '-',
    'PM' => '-  ',
    'SN' => '',
    'VC' => '-  ',
    'KN' => '-  ',
    'LC' => '-',
    'RS' => '',
    'SG' => '',
    'SX' => '-',
    'SY' => '',
    'SK' => '',
    'SI' => '',
    'SB' => ' ',
    'SO' => '',
    'SD' => '',
    'SU' => '',
    'SR' => '',
    'US' => '',
    'SL' => '-',
    'TJ' => '',
    'TH' => '',
    'TZ' => '',
    'TC' => 'Ҹ  ',
    'TG' => '',
    'TK' => '',
    'TO' => '',
    'TT' => '  ',
    'TV' => '',
    'TN' => '',
    'TM' => '',
    'TR' => '',
    'UG' => '',
    'UZ' => '',
    'UA' => '',
    'WF' => '  ',
    'UY' => '',
    'FO' => ' ',
    'FJ' => '',
    'PH' => '',
    'FI' => '',
    'FK' => ' ',
    'FR' => '',
    'PF' => ' ',
    'TF' => '    ',
    'HM' => '  ',
    'HR' => '',
    'CF' => '',
    'TD' => '',
    'ME' => '',
    'CZ' => '',
    'CL' => '',
    'CH' => '',
    'SE' => '',
    'SJ' => '  -',
    'LK' => '-',
    'EC' => '',
    'GQ' => ' ',
    'ER' => '',
    'EE' => '',
    'ET' => '',
    'ZA' => '',
    'GS' => '     ',
    'SS' => ' ',
    'JM' => '',
    'JP' => ''
);

$arGeoCodesEN = array(
    'AF' =>  'Afghanistan',
    'AX' =>  'Aland Islands',
    'AL' =>  'Albania',
    'DZ' =>  'Algeria',
    'AS' =>  'American Samoa',
    'AD' =>  'Andorra',
    'AO' =>  'Angola',
    'AI' =>  'Anguilla',
    'AQ' =>  'Antarctica',
    'AG' =>  'Antigua and Barbuda',
    'AR' =>  'Argentina',
    'AM' =>  'Armenia',
    'AW' =>  'Aruba',
    'AU' =>  'Australia',
    'AT' =>  'Austria',
    'AZ' =>  'Azerbaijan',
    'BS' =>  'Bahamas',
    'BH' =>  'Bahrain',
    'BD' =>  'Bangladesh',
    'BB' =>  'Barbados',
    'BY' =>  'Belarus',
    'BE' =>  'Belgium',
    'BZ' =>  'Belize',
    'BJ' =>  'Benin',
    'BM' =>  'Bermuda',
    'BT' =>  'Bhutan',
    'BO' =>  'Bolivia, Plurinational State of',
    'BQ' =>  'Bonaire, Sint Eustatius and Saba',
    'BA' =>  'Bosnia and Herzegovina',
    'BW' =>  'Botswana',
    'BV' =>  'Bouvet Island',
    'BR' =>  'Brazil',
    'IO' =>  'British Indian Ocean Territory',
    'BN' =>  'Brunei Darussalam',
    'BG' =>  'Bulgaria',
    'BF' =>  'Burkina Faso',
    'BI' =>  'Burundi',
    'KH' =>  'Cambodia',
    'CM' =>  'Cameroon',
    'CA' =>  'Canada',
    'CV' =>  'Cape Verde',
    'KY' =>  'Cayman Islands',
    'CF' =>  'Central African Republic',
    'TD' =>  'Chad',
    'CL' =>  'Chile',
    'CN' =>  'China',
    'CX' =>  'Christmas Island',
    'CC' =>  'Cocos (Keeling) Islands',
    'CO' =>  'Colombia',
    'KM' =>  'Comoros',
    'CG' =>  'Congo',
    'CD' =>  'Congo, the Democratic Republic of the',
    'CK' =>  'Cook Islands',
    'CR' =>  'Costa Rica',
    'CI' =>  'Cote d\'Ivoire',
    'HR' =>  'Croatia',
    'CU' =>  'Cuba',
    'CW' =>  'Curacao',
    'CY' =>  'Cyprus',
    'CZ' =>  'Czech Republic',
    'DK' =>  'Denmark',
    'DJ' =>  'Djibouti',
    'DM' =>  'Dominica',
    'DO' =>  'Dominican Republic',
    'EC' =>  'Ecuador',
    'EG' =>  'Egypt',
    'SV' =>  'El Salvador',
    'GQ' =>  'Equatorial Guinea',
    'ER' =>  'Eritrea',
    'EE' =>  'Estonia',
    'ET' =>  'Ethiopia',
    'FK' =>  'Falkland Islands (Malvinas)',
    'FO' =>  'Faroe Islands',
    'FJ' =>  'Fiji',
    'FI' =>  'Finland',
    'FR' =>  'France',
    'GF' =>  'French Guiana',
    'PF' =>  'French Polynesia',
    'TF' =>  'French Southern Territories',
    'GA' =>  'Gabon',
    'GM' =>  'Gambia',
    'GE' =>  'Georgia',
    'DE' =>  'Germany',
    'GH' =>  'Ghana',
    'GI' =>  'Gibraltar',
    'GR' =>  'Greece',
    'GL' =>  'Greenland',
    'GD' =>  'Grenada',
    'GP' =>  'Guadeloupe',
    'GU' =>  'Guam',
    'GT' =>  'Guatemala',
    'GG' =>  'Guernsey',
    'GN' =>  'Guinea',
    'GW' =>  'Guinea-Bissau',
    'GY' =>  'Guyana',
    'HT' =>  'Haiti',
    'HM' =>  'Heard Island and McDonald Islands',
    'VA' =>  'Holy See (Vatican City State)',
    'HN' =>  'Honduras',
    'HK' =>  'Hong Kong',
    'HU' =>  'Hungary',
    'IS' =>  'Iceland',
    'IN' =>  'India',
    'ID' =>  'Indonesia',
    'IR' =>  'Iran, Islamic Republic of',
    'IQ' =>  'Iraq',
    'IE' =>  'Ireland',
    'IM' =>  'Isle of Man',
    'IL' =>  'Israel',
    'IT' =>  'Italy',
    'JM' =>  'Jamaica',
    'JP' =>  'Japan',
    'JE' =>  'Jersey',
    'JO' =>  'Jordan',
    'KZ' =>  'Kazakhstan',
    'KE' =>  'Kenya',
    'KI' =>  'Kiribati',
    'KP' =>  'Korea, Democratic People\'s Republic of',
    'KR' =>  'Korea, Republic of',
    'KW' =>  'Kuwait',
    'KG' =>  'Kyrgyzstan',
    'LA' =>  'Lao People\'s Democratic Republic',
    'LV' =>  'Latvia',
    'LB' =>  'Lebanon',
    'LS' =>  'Lesotho',
    'LR' =>  'Liberia',
    'LY' =>  'Libya',
    'LI' =>  'Liechtenstein',
    'LT' =>  'Lithuania',
    'LU' =>  'Luxembourg',
    'MO' =>  'Macao',
    'MK' =>  'Macedonia, The Former Yugoslav Republic of',
    'MG' =>  'Madagascar',
    'MW' =>  'Malawi',
    'MY' =>  'Malaysia',
    'MV' =>  'Maldives',
    'ML' =>  'Mali',
    'MT' =>  'Malta',
    'MH' =>  'Marshall Islands',
    'MQ' =>  'Martinique',
    'MR' =>  'Mauritania',
    'MU' =>  'Mauritius',
    'YT' =>  'Mayotte',
    'MX' =>  'Mexico',
    'FM' =>  'Micronesia, Federated States of',
    'MD' =>  'Moldova, Republic of',
    'MC' =>  'Monaco',
    'MN' =>  'Mongolia',
    'ME' =>  'Montenegro',
    'MS' =>  'Montserrat',
    'MA' =>  'Morocco',
    'MZ' =>  'Mozambique',
    'MM' =>  'Myanmar',
    'NA' =>  'Namibia',
    'NR' =>  'Nauru',
    'NP' =>  'Nepal',
    'NL' =>  'Netherlands',
    'NC' =>  'New Caledonia',
    'NZ' =>  'New Zealand',
    'NI' =>  'Nicaragua',
    'NE' =>  'Niger',
    'NG' =>  'Nigeria',
    'NU' =>  'Niue',
    'NF' =>  'Norfolk Island',
    'MP' =>  'Northern Mariana Islands',
    'NO' =>  'Norway',
    'OM' =>  'Oman',
    'PK' =>  'Pakistan',
    'PW' =>  'Palau',
    'PS' =>  'Palestine, State of',
    'PA' =>  'Panama',
    'PG' =>  'Papua New Guinea',
    'PY' =>  'Paraguay',
    'PE' =>  'Peru',
    'PH' =>  'Philippines',
    'PN' =>  'Pitcairn',
    'PL' =>  'Poland',
    'PT' =>  'Portugal',
    'PR' =>  'Puerto Rico',
    'QA' =>  'Qatar',
    'RE' =>  'Reunion',
    'RO' =>  'Romania',
    'RU' =>  'Russian Federation',
    'RW' =>  'Rwanda',
    'BL' =>  'Saint Barthelemy',
    'SH' =>  'Saint Helena, Ascension and Tristan da Cunha',
    'KN' =>  'Saint Kitts and Nevis',
    'LC' =>  'Saint Lucia',
    'MF' =>  'Saint Martin (French part)',
    'PM' =>  'Saint Pierre and Miquelon',
    'VC' =>  'Saint Vincent and the Grenadines',
    'WS' =>  'Samoa',
    'SM' =>  'San Marino',
    'ST' =>  'Sao Tome and Principe',
    'SA' =>  'Saudi Arabia',
    'SN' =>  'Senegal',
    'RS' =>  'Serbia',
    'SC' =>  'Seychelles',
    'SL' =>  'Sierra Leone',
    'SG' =>  'Singapore',
    'SX' =>  'Sint Maarten (Dutch part)',
    'SK' =>  'Slovakia',
    'SI' =>  'Slovenia',
    'SB' =>  'Solomon Islands',
    'SO' =>  'Somalia',
    'ZA' =>  'South Africa',
    'GS' =>  'South Georgia and the South Sandwich Islands',
    'SS' =>  'South Sudan',
    'ES' =>  'Spain',
    'LK' =>  'Sri Lanka',
    'SD' =>  'Sudan',
    'SR' =>  'Suriname',
    'SJ' =>  'Svalbard and Jan Mayen',
    'SZ' =>  'Swaziland',
    'SE' =>  'Sweden',
    'CH' =>  'Switzerland',
    'SY' =>  'Syrian Arab Republic',
    'TW' =>  'Taiwan, Province of China',
    'TJ' =>  'Tajikistan',
    'TZ' =>  'Tanzania, United Republic of',
    'TH' =>  'Thailand',
    'TL' =>  'Timor-Leste',
    'TG' =>  'Togo',
    'TK' =>  'Tokelau',
    'TO' =>  'Tonga',
    'TT' =>  'Trinidad and Tobago',
    'TN' =>  'Tunisia',
    'TR' =>  'Turkey',
    'TM' =>  'Turkmenistan',
    'TC' =>  'Turks and Caicos Islands',
    'TV' =>  'Tuvalu',
    'UG' =>  'Uganda',
    'UA' =>  'Ukraine',
    'AE' =>  'United Arab Emirates',
    'GB' =>  'United Kingdom',
    'US' =>  'United States',
    'UM' =>  'United States Minor Outlying Islands',
    'UY' =>  'Uruguay',
    'UZ' =>  'Uzbekistan',
    'VU' =>  'Vanuatu',
    'VE' =>  'Venezuela, Bolivarian Republic of',
    'VN' =>  'Viet Nam',
    'VG' =>  'Virgin Islands, British',
    'VI' =>  'Virgin Islands, U.S.',
    'WF' =>  'Wallis and Futuna',
    'EH' =>  'Western Sahara',
    'YE' =>  'Yemen',
    'ZM' =>  'Zambia',
    'ZW' =>  'Zimbabwe'
);

header('Content-type: text/html;charset=windows-1251');

var_dump(getGeoLocation('91.230.211.234'));
/*
 array(3) {
  ["country"]=>
  string(6) ""
  ["region"]=>
  string(17) " "
  ["city"]=>
  string(10) ""
}
 */

var_dump(getGeoLocation('173.194.71.100'));